<?php 
    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("nome"=>$cerca) : array();
    $parametri = array("tabella"=>"geec_video", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <title>Amministrazione di Geecom Admin - componente video</title>

    <?php
        include "../include/cssBaseComponenti.php";
    ?>
</head>

<body>
   
    <!-- barra superiore -->
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
    <!-- /riga menu principale -->
    
    
     <!-- Modal box conferma cancellazione elemento-->
    <div class="modal fade" id="myModal3" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel3">Eliminare l'utente: </h4>
                </div>
                <form class="form-horizontal" role="form" name="formCancellazione" action="utenti/cancellaUtente.php" method="post">
                    <input type="text" class="hidden" id="utenteDaEliminare" name="idUtente" >
                </form>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{document.formCancellazione.submit();}" >Elimina</button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->


    <main role="main" class="bg-light">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                            }
                            else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                            }
                            else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                            }
                            else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                            }
                            else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                            }
                        }
                    ?>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"> Elenco video</span>
                            <a href="creaVideo.php" class="btn btn-sm btn-primary" >
                                Crea nuovo<i class="fas fa-plus ml-2"></i>
                            </a>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php

                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }

                                        $colonne = array("ID","Nome","Video","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($video = $ris->fetch_assoc()) {
                                            $nomeEscape = filter_var($video["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                            $azioni = array("modifica"=>"creaVideo.php?id={$video["id"]}","elimina"=>"eliminaOccorrenza({$video["id"]},'$nomeEscape')");
                                            $tabella->aggiungiNuovaRiga(array($video["id"],"<a href=\"creaVideo.php?id={$video["id"]}\"><b>{$video["nome"]}</b></a>",$video["video"]),$azioni);
                                        }

                                        $tabella->stampa("video",0);
                                        $ricerca->stampaPaginazione(true,"gestioneMenu.php");
                                    ?>
                                </div>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
        
        include "../include/modal/eliminaOccorrenza.php";
        
        include "../include/jsBaseComponenti.php";
    ?>
    
    <script type="text/javascript">

        function eliminaOccorrenza(id,nome) {
            document.getElementById("elementoDaEliminare").value = id;
            document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
            $('#modalEliminaOccorrenza').modal('show');
        }
        
        function eseguiEliminazioneOccorrenza() {
            var id = $('#elementoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"controller/controllerVideo.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("video"+id).className = "d-none";
                        $('#modalEliminaOccorrenza').modal('hide');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>